/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import io.neox.neonium.Neonium;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayDeque;
import java.util.Collection;
import me.jellysquid.mods.sodium.client.gl.compat.FogHelper;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderColumn;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.MultidrawChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.cull.ChunkCuller;
import me.jellysquid.mods.sodium.client.render.chunk.cull.ChunkFaceFlags;
import me.jellysquid.mods.sodium.client.render.chunk.cull.graph.ChunkGraphCuller;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderListIterator;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.client.util.math.MathChunkPos;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import me.jellysquid.mods.sodium.common.util.IdTable;
import me.jellysquid.mods.sodium.common.util.collections.FutureDequeDrain;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class ChunkRenderManager<T extends ChunkGraphicsState>
implements ChunkStatusListener {
    private static final double NEARBY_CHUNK_DISTANCE = Math.pow(48.0, 2.0);
    private static final float FOG_PLANE_MIN_DISTANCE = (float)Math.pow(8.0, 2.0);
    private static final float FOG_PLANE_OFFSET = 12.0f;
    private final ChunkBuilder<T> builder;
    private final ChunkRenderBackend<T> backend;
    private final Thread renderThread = Thread.currentThread();
    private final Long2ObjectOpenHashMap<ChunkRenderColumn<T>> columns = new Long2ObjectOpenHashMap();
    private final IdTable<ChunkRenderContainer<T>> renders = new IdTable(16384);
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> importantRebuildQueue = new ObjectArrayFIFOQueue();
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> rebuildQueue = new ObjectArrayFIFOQueue();
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> sortQueue = new ObjectArrayFIFOQueue();
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> unloadQueue = new ObjectArrayFIFOQueue();
    private final ChunkRenderList<T>[] chunkRenderLists = new ChunkRenderList[BlockRenderPass.COUNT];
    private final ObjectList<ChunkRenderContainer<T>> tickableChunks = new ObjectArrayList();
    private final ObjectList<TileEntity> visibleBlockEntities = new ObjectArrayList();
    private final SodiumWorldRenderer renderer;
    private final WorldClient world;
    private final ChunkCuller culler;
    private final boolean useBlockFaceCulling;
    private float cameraX;
    private float cameraY;
    private float cameraZ;
    private boolean dirty;
    private final boolean translucencySorting;
    private int visibleChunkCount;
    private boolean useFogCulling;
    private double fogRenderCutoff;
    private final int translucencyBlockRenderDistance;
    private boolean alwaysDeferChunkUpdates;
    private float lastCameraTranslucentX;
    private float lastCameraTranslucentY;
    private float lastCameraTranslucentZ;
    private boolean hasCameraMovedTranslucent;

    public ChunkRenderManager(SodiumWorldRenderer renderer, ChunkRenderBackend<T> backend, BlockRenderPassManager renderPassManager, WorldClient world, int renderDistance) {
        this.backend = backend;
        this.renderer = renderer;
        this.world = world;
        this.builder = new ChunkBuilder<T>(backend.getVertexType(), this.backend);
        this.builder.init(world, renderPassManager);
        this.dirty = true;
        for (int i = 0; i < this.chunkRenderLists.length; ++i) {
            this.chunkRenderLists[i] = new ChunkRenderList();
        }
        this.culler = new ChunkGraphCuller((World)world, renderDistance);
        this.translucencySorting = Neonium.options().advanced.translucencySorting;
        this.translucencyBlockRenderDistance = Math.min(9216, (renderDistance << 4) * (renderDistance << 4));
        this.useBlockFaceCulling = Neonium.options().advanced.useBlockFaceCulling;
    }

    public void update(float ticks, FrustumExtended frustum, int frame, boolean spectator) {
        this.reset();
        this.unloadPending();
        this.setup(ticks);
        this.iterateChunks(frustum, frame, spectator);
        this.dirty = false;
    }

    private void setup(float ticks) {
        float dist;
        Vec3d pos = this.builder.getCameraPosition();
        this.cameraX = (float)pos.field_72450_a;
        this.cameraY = (float)pos.field_72448_b;
        this.cameraZ = (float)pos.field_72449_c;
        this.useFogCulling = false;
        this.alwaysDeferChunkUpdates = Neonium.options().performance.alwaysDeferChunkUpdates;
        if (Neonium.options().advanced.useFogOcclusion && (dist = FogHelper.getFogCutoff() + 12.0f) != 0.0f) {
            this.useFogCulling = true;
            this.fogRenderCutoff = Math.max(FOG_PLANE_MIN_DISTANCE, dist * dist);
        }
    }

    private void iterateChunks(FrustumExtended frustum, int frame, boolean spectator) {
        if (this.translucencySorting) {
            this.checkTranslucencyCameraMoved();
            if (this.hasCameraMovedTranslucent) {
                for (Object o : this.renders.getElements()) {
                    ChunkRenderContainer render;
                    if (o == null || (render = (ChunkRenderContainer)o).getData().isEmpty() || render.needsRebuild() || !render.canRebuild() || !render.shouldRebuildForTranslucents() || !(render.getSquaredDistance(this.cameraX, this.cameraY, this.cameraZ) < (double)this.translucencyBlockRenderDistance)) continue;
                    render.scheduleSort(false);
                }
            }
        }
        IntArrayList list = this.culler.computeVisible(new Vec3d((double)this.cameraX, (double)this.cameraY, (double)this.cameraZ), frustum, frame, spectator);
        IntListIterator it = list.iterator();
        while (it.hasNext()) {
            ChunkRenderContainer<T> render = this.renders.get(it.nextInt());
            this.addChunk(render);
        }
    }

    private void checkTranslucencyCameraMoved() {
        float dx = this.cameraX - this.lastCameraTranslucentX;
        float dy = this.cameraY - this.lastCameraTranslucentY;
        float dz = this.cameraZ - this.lastCameraTranslucentZ;
        if ((double)(dx * dx + dy * dy + dz * dz) > 1.0) {
            this.lastCameraTranslucentX = this.cameraX;
            this.lastCameraTranslucentY = this.cameraY;
            this.lastCameraTranslucentZ = this.cameraZ;
            this.hasCameraMovedTranslucent = true;
        } else {
            this.hasCameraMovedTranslucent = false;
        }
    }

    private void addChunk(ChunkRenderContainer<T> render) {
        if (render.needsRebuild() && render.canRebuild()) {
            if (!this.alwaysDeferChunkUpdates && render.needsImportantRebuild()) {
                this.importantRebuildQueue.enqueue(render);
            } else {
                this.rebuildQueue.enqueue(render);
            }
        } else if (render.canRebuild() && !render.getData().isEmpty() && render.needsSort()) {
            this.sortQueue.enqueue(render);
        }
        if (this.useFogCulling && render.getSquaredDistanceXZ(this.cameraX, this.cameraZ) >= this.fogRenderCutoff) {
            return;
        }
        if (!render.isEmpty()) {
            this.addChunkToRenderLists(render);
            this.addEntitiesToRenderLists(render);
        }
    }

    private void addChunkToRenderLists(ChunkRenderContainer<T> render) {
        int visibleFaces = this.computeVisibleFaces(render) & render.getFacesWithData();
        if (visibleFaces == 0) {
            return;
        }
        boolean added = false;
        ChunkGraphicsState[] states = render.getGraphicsStates();
        for (int i = 0; i < states.length; ++i) {
            ChunkGraphicsState state = states[i];
            if (state == null) continue;
            ChunkRenderList<ChunkGraphicsState> list = this.chunkRenderLists[i];
            list.add(state, this.translucencySorting && BlockRenderPass.VALUES[i].isTranslucent() ? ChunkFaceFlags.ALL & render.getFacesWithData() : visibleFaces);
            added = true;
        }
        if (added) {
            if (render.isTickable()) {
                this.tickableChunks.add(render);
            }
            ++this.visibleChunkCount;
        }
    }

    private int computeVisibleFaces(ChunkRenderContainer<T> render) {
        if (!this.useBlockFaceCulling) {
            return ChunkFaceFlags.ALL;
        }
        ChunkRenderBounds bounds = render.getBounds();
        int visibleFaces = ChunkFaceFlags.UNASSIGNED;
        if (this.cameraY > bounds.y1 - 3.0f) {
            visibleFaces |= ChunkFaceFlags.UP;
        }
        if (this.cameraY < bounds.y2 + 3.0f) {
            visibleFaces |= ChunkFaceFlags.DOWN;
        }
        if (this.cameraX > bounds.x1 - 3.0f) {
            visibleFaces |= ChunkFaceFlags.EAST;
        }
        if (this.cameraX < bounds.x2 + 3.0f) {
            visibleFaces |= ChunkFaceFlags.WEST;
        }
        if (this.cameraZ > bounds.z1 - 3.0f) {
            visibleFaces |= ChunkFaceFlags.SOUTH;
        }
        if (this.cameraZ < bounds.z2 + 3.0f) {
            visibleFaces |= ChunkFaceFlags.NORTH;
        }
        return visibleFaces;
    }

    private void addEntitiesToRenderLists(ChunkRenderContainer<T> render) {
        Collection<TileEntity> blockEntities = render.getData().getBlockEntities();
        if (!blockEntities.isEmpty()) {
            this.visibleBlockEntities.addAll(blockEntities);
        }
    }

    public ChunkRenderContainer<T> getRender(int x, int y, int z) {
        ChunkRenderColumn column = (ChunkRenderColumn)this.columns.get(ChunkPos.func_77272_a((int)x, (int)z));
        if (column == null) {
            return null;
        }
        return column.getRender(y);
    }

    private void reset() {
        this.rebuildQueue.clear();
        this.importantRebuildQueue.clear();
        this.sortQueue.clear();
        this.visibleBlockEntities.clear();
        for (ChunkRenderList<T> list : this.chunkRenderLists) {
            list.reset();
        }
        this.tickableChunks.clear();
        this.visibleChunkCount = 0;
    }

    private void unloadPending() {
        while (!this.unloadQueue.isEmpty()) {
            ((ChunkRenderContainer)this.unloadQueue.dequeue()).delete();
        }
    }

    public Collection<TileEntity> getVisibleBlockEntities() {
        return this.visibleBlockEntities;
    }

    @Override
    public void onChunkAdded(int x, int z) {
        this.loadChunk(x, z);
    }

    @Override
    public void onChunkRemoved(int x, int z) {
        this.unloadChunk(x, z);
    }

    private void loadChunk(int x, int z) {
        ChunkRenderColumn column = new ChunkRenderColumn(x, z);
        ChunkRenderColumn prev = (ChunkRenderColumn)this.columns.put(ChunkPos.func_77272_a((int)x, (int)z), column);
        if (prev != null) {
            this.unloadSections(prev);
        }
        this.connectNeighborColumns(column);
        this.loadSections(column);
        this.dirty = true;
    }

    private void unloadChunk(int x, int z) {
        ChunkRenderColumn column = (ChunkRenderColumn)this.columns.remove(ChunkPos.func_77272_a((int)x, (int)z));
        if (column == null) {
            return;
        }
        this.disconnectNeighborColumns(column);
        this.unloadSections(column);
        this.dirty = true;
    }

    private void loadSections(ChunkRenderColumn<T> column) {
        int x = column.getX();
        int z = column.getZ();
        for (int y = 0; y < 16; ++y) {
            ChunkRenderContainer<T> render = this.createChunkRender(column, x, y, z);
            column.setRender(y, render);
            this.culler.onSectionLoaded(x, y, z, render.getId());
        }
    }

    private void unloadSections(ChunkRenderColumn<T> column) {
        int x = column.getX();
        int z = column.getZ();
        for (int y = 0; y < 16; ++y) {
            ChunkRenderContainer<T> render = column.getRender(y);
            if (render != null) {
                this.unloadQueue.enqueue(render);
                this.renders.remove(render.getId());
            }
            this.culler.onSectionUnloaded(x, y, z);
        }
    }

    private void connectNeighborColumns(ChunkRenderColumn<T> column) {
        for (EnumFacing dir : DirectionUtil.ALL_DIRECTIONS) {
            ChunkRenderColumn<T> adj = this.getAdjacentColumn(column, dir);
            if (adj != null) {
                adj.setAdjacentColumn(dir.func_176734_d(), column);
            }
            column.setAdjacentColumn(dir, adj);
        }
    }

    private void disconnectNeighborColumns(ChunkRenderColumn<T> column) {
        for (EnumFacing dir : DirectionUtil.ALL_DIRECTIONS) {
            ChunkRenderColumn adj = column.getAdjacentColumn(dir);
            if (adj != null) {
                adj.setAdjacentColumn(dir.func_176734_d(), null);
            }
            column.setAdjacentColumn(dir, null);
        }
    }

    private ChunkRenderColumn<T> getAdjacentColumn(ChunkRenderColumn<T> column, EnumFacing dir) {
        return this.getColumn(column.getX() + dir.func_82601_c(), column.getZ() + dir.func_82599_e());
    }

    private ChunkRenderColumn<T> getColumn(int x, int z) {
        return (ChunkRenderColumn)this.columns.get(ChunkPos.func_77272_a((int)x, (int)z));
    }

    private ChunkRenderContainer<T> createChunkRender(ChunkRenderColumn<T> column, int x, int y, int z) {
        ChunkRenderContainer<T> render = new ChunkRenderContainer<T>(this.backend, this.renderer, x, y, z, column);
        ExtendedBlockStorage array = this.world.func_72964_e(x, z).func_76587_i()[y];
        if (array == null || array.func_76663_a()) {
            render.setData(ChunkRenderData.EMPTY);
        } else {
            render.scheduleRebuild(false);
        }
        render.setId(this.renders.add(render));
        return render;
    }

    public void renderLayer(BlockRenderPass pass, double x, double y, double z) {
        ChunkRenderList<T> chunkRenderList = this.chunkRenderLists[pass.ordinal()];
        ChunkRenderListIterator<T> iterator = chunkRenderList.iterator(pass.isTranslucent());
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        this.backend.begin();
        if (this.backend instanceof MultidrawChunkRenderBackend) {
            ((MultidrawChunkRenderBackend)this.backend).setReverseRegions(pass.isTranslucent());
        }
        this.backend.render(commandList, iterator, new ChunkCameraContext(x, y, z));
        this.backend.end();
        commandList.flush();
    }

    public void tickVisibleRenders() {
        for (ChunkRenderContainer render : this.tickableChunks) {
            render.tick();
        }
    }

    public boolean isChunkVisible(int x, int y, int z) {
        return this.culler.isSectionVisible(x, y, z);
    }

    public void updateChunks() {
        ChunkRenderContainer render;
        this.builder.cleanupSectionCache();
        ArrayDeque futures = new ArrayDeque();
        int budget = this.builder.getSchedulingBudget();
        int submitted = 0;
        while (!this.importantRebuildQueue.isEmpty()) {
            render = (ChunkRenderContainer)this.importantRebuildQueue.dequeue();
            if (render == null) continue;
            if (this.alwaysDeferChunkUpdates || !this.isChunkPrioritized(render)) {
                this.builder.deferRebuild(render);
            } else {
                futures.add(this.builder.scheduleRebuildTaskAsync(render));
            }
            this.dirty = true;
            if (!this.alwaysDeferChunkUpdates || ++submitted < budget) continue;
            break;
        }
        while (submitted < budget && !this.rebuildQueue.isEmpty()) {
            render = (ChunkRenderContainer)this.rebuildQueue.dequeue();
            this.builder.deferRebuild(render);
            ++submitted;
        }
        boolean sortedAnything = false;
        while (!(sortedAnything && submitted >= budget || this.sortQueue.isEmpty())) {
            ChunkRenderContainer render2 = (ChunkRenderContainer)this.sortQueue.dequeue();
            this.builder.deferSort(render2);
            sortedAnything = true;
            ++submitted;
        }
        this.dirty |= submitted > 0;
        this.dirty |= this.builder.performPendingUploads();
        this.builder.handleFailures();
        if (!futures.isEmpty()) {
            this.dirty = true;
            this.backend.upload(RenderDevice.INSTANCE.createCommandList(), this.builder.filterChunkBuilds(new FutureDequeDrain(futures)));
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void restoreChunks(LongCollection chunks) {
        LongIterator it = chunks.iterator();
        while (it.hasNext()) {
            long pos = it.nextLong();
            this.loadChunk(MathChunkPos.getX(pos), MathChunkPos.getZ(pos));
        }
    }

    public boolean isBuildComplete() {
        return this.builder.isBuildQueueEmpty();
    }

    public void setCameraPosition(double x, double y, double z) {
        this.builder.setCameraPosition(x, y, z);
    }

    public void destroy() {
        this.reset();
        for (ChunkRenderColumn column : this.columns.values()) {
            this.unloadSections(column);
        }
        this.columns.clear();
        this.builder.stopWorkers();
    }

    public int getTotalSections() {
        return this.columns.size() * 16;
    }

    public int getRebuildQueueSize() {
        return this.rebuildQueue.size();
    }

    public int getImportantRebuildQueueSize() {
        return this.importantRebuildQueue.size();
    }

    private void scheduleRebuildOffThread(int x, int y, int z, boolean important) {
        Minecraft.func_71410_x().func_152344_a(() -> this.scheduleRebuild(x, y, z, important));
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        if (Thread.currentThread() != this.renderThread) {
            this.scheduleRebuildOffThread(x, y, z, important);
            return;
        }
        ChunkRenderContainer<T> render = this.getRender(x, y, z);
        if (render != null) {
            boolean bl = important = important || this.isChunkPrioritized(render);
            if (render.scheduleRebuild(important) && render.canRebuild()) {
                (render.needsImportantRebuild() ? this.importantRebuildQueue : this.rebuildQueue).enqueue(render);
            }
            this.dirty = true;
        }
        this.builder.onChunkDataChanged(x, y, z);
    }

    public boolean isChunkPrioritized(ChunkRenderContainer<T> render) {
        return render != null && render.getSquaredDistance(this.cameraX, this.cameraY, this.cameraZ) <= NEARBY_CHUNK_DISTANCE;
    }

    public int getVisibleChunkCount() {
        return this.visibleChunkCount;
    }

    public void onChunkRenderUpdates(int x, int y, int z, ChunkRenderData data) {
        this.culler.onSectionStateChanged(x, y, z, data.getOcclusionData());
    }
}

